/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.cmti.sam.datacipher;

import it.uniud.cmti.sam.datacipher.AES;
import it.uniud.cmti.sam.datacipher.Blowfish;
import it.uniud.cmti.sam.datacipher.DES;
import it.uniud.cmti.sam.datacipher.Hash;
import it.uniud.cmti.sam.datacipher.lang.Language;
import it.uniud.cmti.sam.datacipher.options.Options;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Cursor;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebView;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class DataCipherFXMLController
implements Initializable {
    private final String RED = "#F77";
    private final String GREEN = "#9BC89B";
    private String OPT_FILE_PATH;
    private Options options;
    private String selectedLanguage;
    private boolean fileLanguageExist = true;
    private boolean fileOptionsExist = true;
    private boolean jceInstalled = false;
    private String appPath = "";
    private final String pathSep = File.separator;
    private String lastPathOpened = "";
    private String fileType = "";
    private String encPathFile = "";
    private String encSourceFileName = "";
    private String encDestinationFileName = "";
    private String encDestinationFolder = "";
    private String decPathFile = "";
    private String decSourceFileName = "";
    private String decDestinationFileName = "";
    private String decDestinationFolder = "";
    private String algorithmChoosen = "";
    private String encryptionKey = "";
    private String decryptionKey = "";
    private String hashAlgorithmChoosen = "";
    private String hashPathFile = "";
    private int keyMaxLenght = 8;
    private ObservableList<String> fileList;
    private Task worker;
    @FXML
    private Tab tab_cryptTitle;
    @FXML
    private Tab tab_decryptTitle;
    @FXML
    private Tab tab_hashTitle;
    @FXML
    private Tab tab_optionsTitle;
    @FXML
    private Tab tab_helpTitle;
    @FXML
    private WebView web_help;
    @FXML
    private AnchorPane anc_message;
    @FXML
    private Label lbl_fileToBeEncrypted;
    @FXML
    private Label lbl_encryptionAlgortihm;
    @FXML
    private Label lbl_encryptionKey;
    @FXML
    private Label lbl_saveEncryptedFileHere;
    @FXML
    private Label lbl_fileToBeDecrypted;
    @FXML
    private Label lbl_decryptionAlgorithm;
    @FXML
    private Label lbl_decryptionKey;
    @FXML
    private Label lbl_saveDecryptedFileHere;
    @FXML
    private Label lbl_fileToBeAshed;
    @FXML
    private Label lbl_hashAlgotirthm;
    @FXML
    private Label lbl_hashCode;
    @FXML
    private Label lbl_language;
    @FXML
    private Label lb_message;
    @FXML
    private TextField txt_pathSource;
    @FXML
    private TextField txt_pathDestination;
    @FXML
    private TextField txt_key;
    @FXML
    private TextField txt_decPathSource;
    @FXML
    private TextField txt_decKey;
    @FXML
    private TextField txt_decPathDestination;
    @FXML
    private TextField txt_hashPathSource;
    @FXML
    private TextField txt_hashCode;
    @FXML
    private ChoiceBox ch_cryptEncryptAlg;
    @FXML
    private ChoiceBox ch_keyLength;
    @FXML
    private ChoiceBox ch_decryptEncryptAlg;
    @FXML
    private ChoiceBox ch_hashAlg;
    @FXML
    private ChoiceBox ch_language;
    @FXML
    private Button bt_chooseFile;
    @FXML
    private Button bt_crypt;
    @FXML
    private Button bt_chooseFolder;
    @FXML
    private Button bt_decChooseFile;
    @FXML
    private Button bt_decChooseFolder;
    @FXML
    private Button bt_decrypt;
    @FXML
    private Button bt_hashChooseFile;
    @FXML
    private Button bt_hash;

    @FXML
    private void chooseFile(Event ev) {
        String idButton = ((Button)ev.getSource()).getId();
        if (KeyEvent.class.isInstance(ev)) {
            KeyEvent g = (KeyEvent)ev;
            String evType = g.getCode().toString();
            if (evType.equalsIgnoreCase("ENTER") || evType.equalsIgnoreCase("SPACE")) {
                this.chooseFile(idButton);
            }
        } else {
            this.chooseFile(idButton);
        }
    }

    @FXML
    private void chooseFolder(Event ev) {
        String idButton = ((Button)ev.getSource()).getId();
        if (KeyEvent.class.isInstance(ev)) {
            KeyEvent g = (KeyEvent)ev;
            String evType = g.getCode().toString();
            if (evType.equalsIgnoreCase("ENTER") || evType.equalsIgnoreCase("SPACE")) {
                this.chooseFolder(idButton);
            }
        } else {
            this.chooseFolder(idButton);
        }
    }

    @FXML
    private void encrypt(Event ev) {
        if (KeyEvent.class.isInstance(ev)) {
            KeyEvent g = (KeyEvent)ev;
            String evType = g.getCode().toString();
            if (evType.equalsIgnoreCase("ENTER") || evType.equalsIgnoreCase("SPACE")) {
                this.callEncryptor();
            }
        } else {
            this.callEncryptor();
        }
    }

    @FXML
    private void decrypt(Event ev) {
        if (KeyEvent.class.isInstance(ev)) {
            KeyEvent g = (KeyEvent)ev;
            String evType = g.getCode().toString();
            if (evType.equalsIgnoreCase("ENTER") || evType.equalsIgnoreCase("SPACE")) {
                this.callDecryptor();
            }
        } else {
            this.callDecryptor();
        }
    }

    @FXML
    private void hash(Event ev) {
        if (KeyEvent.class.isInstance(ev)) {
            KeyEvent g = (KeyEvent)ev;
            String evType = g.getCode().toString();
            if (evType.equalsIgnoreCase("ENTER") || evType.equalsIgnoreCase("SPACE")) {
                this.callHash();
            }
        } else {
            this.callHash();
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.fileList = FXCollections.observableArrayList();
        this.readLanguageFiles();
        this.readOptions();
        this.translateInterface();
        this.appPath = new File("").getAbsolutePath() + this.pathSep;
        this.OPT_FILE_PATH = this.appPath + "options" + this.pathSep + "options.xml";
        this.anc_message.setVisible(false);
        this.ch_cryptEncryptAlg.setItems(FXCollections.observableArrayList((Object[])new String[]{"Blowfish", "DES", "AES"}));
        this.ch_decryptEncryptAlg.setItems(FXCollections.observableArrayList((Object[])new String[]{"Blowfish", "DES", "AES"}));
        this.ch_hashAlg.setItems(FXCollections.observableArrayList((Object[])new String[]{"SHA-1", "SHA-256", "SHA-384", "SHA-512"}));
        this.ch_keyLength.setItems(FXCollections.observableArrayList((Object[])new String[]{"64 bit", "128 bit", "256 bit"}));
        this.bt_chooseFile.setCursor(Cursor.HAND);
        this.bt_chooseFolder.setCursor(Cursor.HAND);
        this.bt_crypt.setCursor(Cursor.HAND);
        this.bt_decChooseFile.setCursor(Cursor.HAND);
        this.bt_decChooseFolder.setCursor(Cursor.HAND);
        this.bt_decrypt.setCursor(Cursor.HAND);
        this.bt_hashChooseFile.setCursor(Cursor.HAND);
        this.bt_hash.setCursor(Cursor.HAND);
        this.lb_message.setCursor(Cursor.HAND);
        this.lb_message.setTooltip(new Tooltip("Click to close this message"));
        this.jceInstalled = AES.isJceInstalled();
        URL urlHello = this.getClass().getResource("help/help.html");
        this.web_help.getEngine().load(urlHello.toExternalForm());
        this.lb_message.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                DataCipherFXMLController.this.showHideMessage("RED", "HAND", false);
            }
        });
        this.ch_cryptEncryptAlg.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number newValue) {
                switch (newValue.intValue()) {
                    case 0: {
                        DataCipherFXMLController.this.algorithmChoosen = "Blowfish";
                        DataCipherFXMLController.this.ch_keyLength.setDisable(false);
                        break;
                    }
                    case 1: {
                        DataCipherFXMLController.this.algorithmChoosen = "DES";
                        DataCipherFXMLController.this.ch_keyLength.setDisable(true);
                        DataCipherFXMLController.this.ch_keyLength.getSelectionModel().select(0);
                        break;
                    }
                    case 2: {
                        DataCipherFXMLController.this.algorithmChoosen = "AES";
                        DataCipherFXMLController.this.ch_keyLength.setDisable(false);
                    }
                }
            }
        });
        this.ch_decryptEncryptAlg.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number newValue) {
                switch (newValue.intValue()) {
                    case 0: {
                        DataCipherFXMLController.this.algorithmChoosen = "Blowfish";
                        break;
                    }
                    case 1: {
                        DataCipherFXMLController.this.algorithmChoosen = "DES";
                        break;
                    }
                    case 2: {
                        DataCipherFXMLController.this.algorithmChoosen = "AES";
                    }
                }
            }
        });
        this.ch_hashAlg.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number newValue) {
                switch (newValue.intValue()) {
                    case 0: {
                        DataCipherFXMLController.this.hashAlgorithmChoosen = "SHA-1";
                        break;
                    }
                    case 1: {
                        DataCipherFXMLController.this.hashAlgorithmChoosen = "SHA-256";
                        break;
                    }
                    case 2: {
                        DataCipherFXMLController.this.hashAlgorithmChoosen = "SHA-384";
                        break;
                    }
                    case 3: {
                        DataCipherFXMLController.this.hashAlgorithmChoosen = "SHA-512";
                    }
                }
            }
        });
        this.ch_language.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number newValue) {
                DataCipherFXMLController.this.selectedLanguage = DataCipherFXMLController.this.ch_language.getItems().get(newValue.intValue()).toString();
                if (DataCipherFXMLController.this.options != null) {
                    DataCipherFXMLController.this.options.setLanguage(DataCipherFXMLController.this.selectedLanguage);
                    DataCipherFXMLController.this.translateInterface();
                    DataCipherFXMLController.this.writeOptions();
                } else {
                    DataCipherFXMLController.this.lb_message.setText("It seems that there's an error in \"options\" folder. Does the folder exist?");
                    DataCipherFXMLController.this.showHideMessage("RED", "HAND", true);
                }
            }
        });
        this.txt_key.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String old, String newV) {
                String text = DataCipherFXMLController.this.txt_key.getText();
                text = text.replaceAll(" ", "");
                DataCipherFXMLController.this.txt_key.setText(text);
                if (DataCipherFXMLController.this.txt_key.getLength() >= DataCipherFXMLController.this.keyMaxLenght) {
                    text = DataCipherFXMLController.this.txt_key.getText().substring(0, DataCipherFXMLController.this.keyMaxLenght);
                    DataCipherFXMLController.this.txt_key.setText(text);
                    DataCipherFXMLController.this.txt_key.setStyle("-fx-control-inner-background: #FFF");
                } else {
                    DataCipherFXMLController.this.txt_key.setStyle("-fx-control-inner-background: #F77");
                }
                DataCipherFXMLController.this.encryptionKey = DataCipherFXMLController.this.txt_key.getText();
            }
        });
        this.ch_keyLength.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number newValue) {
                DataCipherFXMLController.this.txt_key.setText("");
                DataCipherFXMLController.this.txt_key.setEditable(true);
                switch (newValue.intValue()) {
                    case 0: {
                        DataCipherFXMLController.this.keyMaxLenght = 8;
                        break;
                    }
                    case 1: {
                        DataCipherFXMLController.this.keyMaxLenght = 16;
                        break;
                    }
                    case 2: {
                        if (DataCipherFXMLController.this.jceInstalled) {
                            DataCipherFXMLController.this.keyMaxLenght = 32;
                            break;
                        }
                        DataCipherFXMLController.this.lb_message.setText("It seems that you are not installed JCE, so you can't use a 256 bit key. Read HELP for more...");
                        DataCipherFXMLController.this.showHideMessage("RED", "HAND", true);
                        DataCipherFXMLController.this.ch_keyLength.getSelectionModel().select(1);
                    }
                }
            }
        });
        if (!this.fileOptionsExist) {
            this.lb_message.setText("There was a problem with options file! It'll be ignored...");
            this.showHideMessage("RED", "HAND", true);
        }
        if (!this.fileLanguageExist && this.fileOptionsExist) {
            this.lb_message.setText("There was a problem with language file! It'll be ignored...");
            this.showHideMessage("RED", "HAND", true);
        }
    }

    private void readLanguageFiles() {
        File langDir = new File(this.appPath + "lang" + this.pathSep);
        if (langDir.exists()) {
            File[] list;
            for (File list1 : list = langDir.listFiles()) {
                if (!list1.getName().substring(3, 6).equalsIgnoreCase("xml")) continue;
                this.fileList.add((Object)list1.getName().substring(0, 2));
            }
            this.ch_language.setItems(this.fileList);
        } else {
            this.fileLanguageExist = false;
        }
    }

    private void readOptions() {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Options.class});
            Unmarshaller un = context.createUnmarshaller();
            File optionsFile = new File(this.appPath + "options" + this.pathSep + "options.xml");
            if (!optionsFile.exists()) {
                this.options = new Options();
                this.options.setLanguage("en");
                this.fileOptionsExist = false;
            } else {
                this.options = (Options)un.unmarshal(optionsFile);
                this.selectedLanguage = this.options.getLanguage();
            }
        }
        catch (JAXBException e) {
            System.out.println("selectedLanguage: " + this.selectedLanguage);
            this.fileOptionsExist = false;
        }
    }

    private void translateInterface() {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Language.class});
            Unmarshaller un = context.createUnmarshaller();
            File languageFile = new File(this.appPath + "lang" + this.pathSep + this.selectedLanguage + ".xml");
            if (!languageFile.exists()) {
                this.fileLanguageExist = false;
                languageFile = null;
                un = null;
                context = null;
            } else {
                Language lang = (Language)un.unmarshal(languageFile);
                this.tab_cryptTitle.setText(lang.getTab_cryptTitle());
                this.tab_decryptTitle.setText(lang.getTab_decryptTitle());
                this.tab_hashTitle.setText(lang.getTab_hashTitle());
                this.tab_optionsTitle.setText(lang.getTab_optionsTitle());
                this.tab_helpTitle.setText(lang.getTab_helpTitle());
                this.lbl_fileToBeEncrypted.setText(lang.getLbl_fileToBeEncrypted());
                this.txt_pathSource.setPromptText(lang.getTxt_pathSource());
                this.lbl_encryptionAlgortihm.setText(lang.getLbl_encryptionAlgortihm());
                this.lbl_encryptionKey.setText(lang.getLbl_encryptionKey());
                this.txt_key.setPromptText(lang.getTxt_key());
                this.lbl_saveEncryptedFileHere.setText(lang.getLbl_saveEncryptedFileHere());
                this.txt_pathDestination.setPromptText(lang.getTxt_pathDestination());
                this.bt_crypt.setText(lang.getBt_crypt());
                this.lbl_fileToBeDecrypted.setText(lang.getLbl_fileToBeDecrypted());
                this.txt_decPathSource.setPromptText(lang.getTxt_decPathSource());
                this.lbl_decryptionAlgorithm.setText(lang.getLbl_encryptionAlgortihm());
                this.lbl_decryptionKey.setText(lang.getLbl_decryptionKey());
                this.txt_decKey.setPromptText(lang.getTxt_decKey());
                this.lbl_saveDecryptedFileHere.setText(lang.getLbl_saveDecryptedFileHere());
                this.bt_decrypt.setText(lang.getBt_decrypt());
                this.lbl_fileToBeAshed.setText(lang.getLbl_fileToBeAshed());
                this.txt_hashPathSource.setPromptText(lang.getTxt_hashPathSource());
                this.lbl_hashAlgotirthm.setText(lang.getLbl_hashAlgotirthm());
                this.lbl_hashCode.setText(lang.getLbl_hashCode());
                this.bt_hash.setText(lang.getBt_hash());
                this.lbl_language.setText(lang.getLbl_language());
            }
        }
        catch (JAXBException e) {
            this.fileLanguageExist = false;
            e.printStackTrace();
        }
    }

    private void writeOptions() {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Options.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)this.options, new File(this.OPT_FILE_PATH));
        }
        catch (JAXBException e) {
            this.lb_message.setText("An error has occurred saving Options. Try to restart application");
            this.showHideMessage("RED", "HAND", true);
        }
    }

    private boolean isEncryptionDataCorrect() {
        int MAXSIZE = 1000000000;
        boolean itsOK = false;
        if (!(this.encPathFile.equalsIgnoreCase("") || this.algorithmChoosen.equalsIgnoreCase("") || this.txt_key.getLength() != this.keyMaxLenght || this.encDestinationFolder.equalsIgnoreCase(""))) {
            itsOK = true;
            File fileToEncrypt = new File(this.encPathFile);
            Path path = Paths.get(this.encDestinationFolder, new String[0]);
            if (fileToEncrypt.length() > 1000000000L) {
                itsOK = false;
                this.lb_message.setText("Pay attention! Selected file is too large [" + fileToEncrypt.length() / 1024L / 1024L + " MB]!");
                this.showHideMessage("RED", "HAND", true);
            } else if (!Files.isWritable(path)) {
                itsOK = false;
                this.lb_message.setText("You have no rights to write in selected folder");
                this.showHideMessage("RED", "HAND", true);
            } else if (this.algorithmChoosen.equalsIgnoreCase("AES") && this.keyMaxLenght == 8) {
                itsOK = false;
                this.lb_message.setText("With AES you must use at least a 128 bit key");
                this.showHideMessage("RED", "HAND", true);
            }
        } else {
            this.lb_message.setText("Pay Attention! Fill all fields before try to crypt.");
            this.showHideMessage("RED", "HAND", true);
        }
        return itsOK;
    }

    private void callEncryptor() {
        if (this.isEncryptionDataCorrect()) {
            if (this.worker != null) {
                this.worker.cancel();
            }
            try {
                this.worker = this.encryptionTask();
                this.bt_crypt.setText("Encrypting...");
                this.lb_message.setText("Encrypting...");
                this.showHideMessage("GREEN", "WAIT", true);
                new Thread((Runnable)this.worker).start();
            }
            catch (Exception exc) {
                this.lb_message.setText("Error: " + exc.getMessage());
                this.showHideMessage("RED", "HAND", true);
            }
        }
    }

    private Task encryptionTask() {
        return new Task(){

            public Void call() throws Exception {
                switch (DataCipherFXMLController.this.algorithmChoosen) {
                    case "Blowfish": {
                        Blowfish.encrypt(DataCipherFXMLController.this.encryptionKey, new File(DataCipherFXMLController.this.encPathFile), new File(DataCipherFXMLController.this.encDestinationFolder + DataCipherFXMLController.this.pathSep + DataCipherFXMLController.this.encDestinationFileName));
                        break;
                    }
                    case "AES": {
                        AES.encrypt(DataCipherFXMLController.this.encryptionKey, new File(DataCipherFXMLController.this.encPathFile), new File(DataCipherFXMLController.this.encDestinationFolder + DataCipherFXMLController.this.pathSep + DataCipherFXMLController.this.encDestinationFileName));
                        break;
                    }
                    case "DES": {
                        DES.encrypt(DataCipherFXMLController.this.encryptionKey, new File(DataCipherFXMLController.this.encPathFile), new File(DataCipherFXMLController.this.encDestinationFolder + DataCipherFXMLController.this.pathSep + DataCipherFXMLController.this.encDestinationFileName));
                    }
                }
                return null;
            }

            protected void succeeded() {
                super.succeeded();
                DataCipherFXMLController.this.bt_crypt.setText("CRYPT");
                DataCipherFXMLController.this.lb_message.setText("Encryption done!");
                DataCipherFXMLController.this.showHideMessage("GREEN", "HAND", true);
            }

            protected void cancelled() {
                super.cancelled();
            }

            protected void failed() {
                super.failed();
                DataCipherFXMLController.this.bt_crypt.setText("CRYPT");
                DataCipherFXMLController.this.lb_message.setText("There was an error. Encryption was NOT done. Try again...");
                DataCipherFXMLController.this.showHideMessage("RED", "HAND", true);
            }
        };
    }

    private boolean isDecryptionDataCorrect() {
        int MAXSIZE = 1000000000;
        boolean itsOK = false;
        if (!(this.decPathFile.equalsIgnoreCase("") || this.algorithmChoosen.equalsIgnoreCase("") || this.txt_decKey.getLength() <= 7 || this.decDestinationFolder.equalsIgnoreCase(""))) {
            itsOK = true;
            File fileToDecrypt = new File(this.decPathFile);
            Path path = Paths.get(this.decDestinationFolder, new String[0]);
            if (fileToDecrypt.length() > 1000000000L) {
                itsOK = false;
                this.lb_message.setText("Pay attention! Selected file is too large [" + fileToDecrypt.length() / 1024L / 1024L + " MB]!");
                this.showHideMessage("RED", "HAND", true);
            } else if (!Files.isWritable(path)) {
                itsOK = false;
                this.lb_message.setText("You have no rights to write in selected folder");
                this.showHideMessage("RED", "HAND", true);
            }
        } else {
            this.lb_message.setText("Pay Attention! Fill all fields before try to decrypt.");
            this.showHideMessage("RED", "HAND", true);
        }
        return itsOK;
    }

    private void callDecryptor() {
        if (this.isDecryptionDataCorrect()) {
            if (this.worker != null) {
                this.worker.cancel();
            }
            try {
                this.decryptionKey = this.txt_decKey.getText();
                System.out.println(this.decryptionKey);
                this.worker = this.decryptionTask();
                this.bt_decrypt.setText("Decrypting...");
                this.lb_message.setText("Decrypting...");
                this.showHideMessage("GREEN", "WAIT", true);
                new Thread((Runnable)this.worker).start();
            }
            catch (Exception exc) {
                this.lb_message.setText("Error: " + exc.getMessage());
                this.showHideMessage("RED", "HAND", true);
            }
        }
    }

    private Task decryptionTask() {
        return new Task(){

            public Void call() throws Exception {
                switch (DataCipherFXMLController.this.algorithmChoosen) {
                    case "Blowfish": {
                        Blowfish.decrypt(DataCipherFXMLController.this.decryptionKey, new File(DataCipherFXMLController.this.decPathFile), new File(DataCipherFXMLController.this.decDestinationFolder + DataCipherFXMLController.this.pathSep + DataCipherFXMLController.this.decDestinationFileName));
                        break;
                    }
                    case "AES": {
                        AES.decrypt(DataCipherFXMLController.this.decryptionKey, new File(DataCipherFXMLController.this.decPathFile), new File(DataCipherFXMLController.this.decDestinationFolder + DataCipherFXMLController.this.pathSep + DataCipherFXMLController.this.decDestinationFileName));
                        break;
                    }
                    case "DES": {
                        DES.decrypt(DataCipherFXMLController.this.decryptionKey, new File(DataCipherFXMLController.this.decPathFile), new File(DataCipherFXMLController.this.decDestinationFolder + DataCipherFXMLController.this.pathSep + DataCipherFXMLController.this.decDestinationFileName));
                    }
                }
                return null;
            }

            protected void succeeded() {
                super.succeeded();
                DataCipherFXMLController.this.bt_decrypt.setText("DECRYPT");
                DataCipherFXMLController.this.lb_message.setText("Decryption done!");
                DataCipherFXMLController.this.showHideMessage("GREEN", "HAND", true);
            }

            protected void cancelled() {
                super.cancelled();
            }

            protected void failed() {
                super.failed();
                DataCipherFXMLController.this.bt_decrypt.setText("DECRYPT");
                DataCipherFXMLController.this.lb_message.setText("Ops! Decryption was NOT done! Maybe another key...");
                DataCipherFXMLController.this.showHideMessage("RED", "HAND", true);
            }
        };
    }

    private void callHash() {
        if (this.worker != null) {
            this.worker.cancel();
        }
        if (!this.txt_hashPathSource.getText().equalsIgnoreCase("") && !this.hashAlgorithmChoosen.equalsIgnoreCase("")) {
            this.worker = this.hashTask();
            this.bt_hash.setText("Hashing...");
            this.lb_message.setText("Hashing...");
            this.showHideMessage("GREEN", "WAIT", true);
            new Thread((Runnable)this.worker).start();
        } else {
            this.lb_message.setText("Pay Attention! Fill all fields before try to hashing.");
            this.showHideMessage("RED", "HAND", true);
        }
    }

    private Task hashTask() {
        return new Task(){
            String hashCode;

            public Void call() throws Exception {
                switch (DataCipherFXMLController.this.hashAlgorithmChoosen) {
                    case "SHA-1": {
                        this.hashCode = Hash.SHA1(new File(DataCipherFXMLController.this.hashPathFile));
                        break;
                    }
                    case "SHA-256": {
                        this.hashCode = Hash.SHA256(new File(DataCipherFXMLController.this.hashPathFile));
                        break;
                    }
                    case "SHA-384": {
                        this.hashCode = Hash.SHA384(new File(DataCipherFXMLController.this.hashPathFile));
                        break;
                    }
                    case "SHA-512": {
                        this.hashCode = Hash.SHA512(new File(DataCipherFXMLController.this.hashPathFile));
                    }
                }
                return null;
            }

            protected void succeeded() {
                super.succeeded();
                DataCipherFXMLController.this.txt_hashCode.setText(this.hashCode);
                DataCipherFXMLController.this.bt_hash.setText("HASH");
                DataCipherFXMLController.this.lb_message.setText("HASH done!");
                DataCipherFXMLController.this.showHideMessage("GREEN", "HAND", true);
            }

            protected void cancelled() {
                super.cancelled();
            }

            protected void failed() {
                super.failed();
                DataCipherFXMLController.this.bt_hash.setText("HASH");
                DataCipherFXMLController.this.lb_message.setText("Ops! Hashing was NOT done.");
                DataCipherFXMLController.this.showHideMessage("RED", "HAND", true);
            }
        };
    }

    private void chooseFile(String idButton) {
        try {
            int result;
            JFileChooser fileChooser = new JFileChooser();
            if (!this.lastPathOpened.equalsIgnoreCase("")) {
                fileChooser.setCurrentDirectory(new File(this.lastPathOpened));
            } else {
                fileChooser.setCurrentDirectory(new File(this.appPath));
            }
            if (idButton.equalsIgnoreCase("bt_chooseFile")) {
                int result2 = fileChooser.showOpenDialog(null);
                if (result2 == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    this.fileType = Files.probeContentType(selectedFile.toPath());
                    if (this.fileType == null) {
                        this.lb_message.setText("Pay attention! Unrecognized selected file.");
                        this.showHideMessage("RED", "HAND", true);
                        this.txt_pathSource.setText("");
                        this.bt_chooseFolder.setDisable(true);
                    } else {
                        this.fileType = this.fileType.split("/")[0];
                        this.txt_pathSource.setText(selectedFile.getAbsolutePath());
                        this.encPathFile = selectedFile.getAbsolutePath();
                        this.encSourceFileName = selectedFile.getName();
                        this.encDestinationFileName = this.encSourceFileName + ".sam";
                        this.lastPathOpened = selectedFile.getParent();
                        this.bt_chooseFolder.setDisable(false);
                        this.txt_pathDestination.setText(selectedFile.getAbsolutePath() + ".sam");
                        this.encDestinationFolder = this.lastPathOpened;
                    }
                }
            } else if (idButton.equalsIgnoreCase("bt_decChooseFile")) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("SAM File", "sam");
                fileChooser.setFileFilter(filter);
                int result3 = fileChooser.showOpenDialog(null);
                if (result3 == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    this.txt_decPathSource.setText(selectedFile.getAbsolutePath());
                    this.decPathFile = selectedFile.getAbsolutePath();
                    this.decSourceFileName = selectedFile.getName();
                    this.decDestinationFileName = this.decSourceFileName.substring(0, this.decSourceFileName.length() - 4);
                    this.lastPathOpened = selectedFile.getParent();
                    this.bt_decChooseFolder.setDisable(false);
                    this.txt_decPathDestination.setText(selectedFile.getAbsolutePath().substring(0, selectedFile.getAbsolutePath().length() - 4));
                    this.decDestinationFolder = this.lastPathOpened;
                }
            } else if (idButton.equalsIgnoreCase("bt_hashChooseFile") && (result = fileChooser.showOpenDialog(null)) == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                this.txt_hashPathSource.setText(selectedFile.getAbsolutePath());
                this.hashPathFile = selectedFile.getAbsolutePath();
                this.lastPathOpened = selectedFile.getParent();
            }
        }
        catch (HeadlessException | IOException exc) {
            this.lb_message.setText("Unexpected error [click to close]: " + exc.getMessage());
            this.showHideMessage("RED", "HAND", true);
        }
    }

    private void chooseFolder(String idButton) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            if (!this.lastPathOpened.equalsIgnoreCase("")) {
                fileChooser.setCurrentDirectory(new File(this.lastPathOpened));
            } else {
                fileChooser.setCurrentDirectory(new File(this.appPath));
            }
            fileChooser.setFileSelectionMode(1);
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                if (idButton.equalsIgnoreCase("bt_chooseFolder")) {
                    this.txt_pathDestination.setText(selectedFile.getAbsolutePath() + this.pathSep + this.encSourceFileName + ".sam");
                    this.encDestinationFolder = selectedFile.getAbsolutePath();
                } else {
                    this.decDestinationFileName = this.decSourceFileName.substring(0, this.decSourceFileName.length() - 4);
                    this.txt_decPathDestination.setText(selectedFile.getAbsolutePath() + this.pathSep + this.decDestinationFileName);
                    this.decDestinationFolder = selectedFile.getAbsolutePath();
                }
            }
        }
        catch (HeadlessException exc) {
            this.lb_message.setText("Unexpected error [click to close]: " + exc.getMessage());
            this.showHideMessage("RED", "HAND", true);
        }
    }

    private void showHideMessage(String type, String wait, boolean show) {
        switch (type.toUpperCase()) {
            case "RED": {
                this.lb_message.setStyle("-fx-background-color: #F77");
                break;
            }
            case "GREEN": {
                this.lb_message.setStyle("-fx-background-color: #9BC89B");
            }
        }
        this.anc_message.setCursor(Cursor.DEFAULT);
        switch (wait.toUpperCase()) {
            case "HAND": {
                this.lb_message.setCursor(Cursor.HAND);
                break;
            }
            case "WAIT": {
                this.anc_message.setCursor(Cursor.WAIT);
                break;
            }
            case "NORMAL": {
                this.anc_message.setCursor(Cursor.DEFAULT);
            }
        }
        this.anc_message.setVisible(show);
    }
}

