/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.cmti.sam.datacipher;

import it.uniud.cmti.sam.datacipher.CryptoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class AES {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES";

    public static void encrypt(String key, File inputFile, File outputFile) throws CryptoException {
        AES.doCrypto(1, key, inputFile, outputFile);
    }

    public static void decrypt(String key, File inputFile, File outputFile) throws CryptoException {
        AES.doCrypto(2, key, inputFile, outputFile);
    }

    private static void doCrypto(int cipherMode, String key, File inputFile, File outputFile) throws CryptoException {
        Long fileDimension = outputFile.length();
        Integer intFileDimension = fileDimension != null ? fileDimension.intValue() : 0;
        try {
            System.out.println("LENGHT: " + inputFile.length());
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "AES");
            System.out.println(secretKey.getAlgorithm() + " - " + secretKey.toString());
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(cipherMode, secretKey);
            System.out.println("DIM: " + intFileDimension + " - DIM FINALE: " + cipher.getOutputSize(intFileDimension));
            FileInputStream inputStream = new FileInputStream(inputFile);
            byte[] inputBytes = new byte[(int)inputFile.length()];
            inputStream.read(inputBytes);
            byte[] outputBytes = cipher.doFinal(inputBytes);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            outputStream.write(outputBytes);
            inputStream.close();
            outputStream.close();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Error encrypting/decrypting file", ex);
        }
    }

    public static boolean isJceInstalled() {
        try {
            int maxLengthKey = Cipher.getMaxAllowedKeyLength("AES");
            return maxLengthKey != 128;
        }
        catch (NoSuchAlgorithmException ex) {
            return false;
        }
    }
}

